### Why does decision making matter?

You make decisions every day, big and small. But choosing wisely isn’t easy. You don’t have time to linger over every choice, yet your first intuitions aren’t always right. There are blind spots that can systematically bias how you decide. And many options involve risks that are not resolved until after you’ve made your choice. Everyone uses mental shortcuts that can sometimes lead us to make decisions that are less than optimal—so what’s important is knowing how and when to correct for their influence.

## **Pulse Check**

Reflect on your current style of decision making. How many of the following are true for you—and how eager are you to correct them?

- I’ve bought clothes or shoes that I’ve never worn.
- I tend to make choices quickly without considering alternatives.
- I often regret how I spend my day.
- When making decisions, I mostly look for evidence supporting my initial hunch.

### How do I nurture decision making in others?

**Model it.** When you make a decision, explain how you came to that conclusion. For possible options, spell out the pros and cons, their importance, and how likely they are to happen. Make sure that the risks you take are worth the rewards they could deliver. Talk about what would be the best- and worst-case scenarios—and which scenario is most likely: _“If we go out, we will probably enjoy a sunny afternoon at the beach together, but there’s also a small chance we’ll get caught in rain or traffic. If we stay home, we’ll almost certainly order pizza, turn on a movie, and stare at our phones.”_

**Celebrate it.** Applaud processes, not outcomes. When options are risky, good decisions can have bad results. Show that you’re tolerant of risk, as long as the reasons for taking risks are sound: _“That didn’t work out, but you made the right call! I would have made the same decision.”_

**Enable it.** Give young people a chance to think about all sides of a decision, and avoid leading questions so they follow your hunch. Instead of _“We should…”_, try _“Which should…”_. When making a decision with friends or family, assign someone to play devil’s advocate. Have groups argue for different positions. Making the case for alternatives reveals blinders and biases in our own thinking.